/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.api.v2.ComposterAPI;
import org.betterx.betterend.item.tool.EndHammerItem;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.tag.v3.TagManager;

public class EndTags {
    public static final TagKey<Block> PEDESTALS = TagManager.BLOCKS.makeTag("betterend", "pedestal");
    public static final TagKey<Item> ALLOYING_IRON = TagManager.ITEMS.makeTag("betterend", "alloying_iron");
    public static final TagKey<Item> ALLOYING_GOLD = TagManager.ITEMS.makeTag("betterend", "alloying_gold");
    public static final TagKey<Item> ALLOYING_COPPER = TagManager.ITEMS.makeTag("betterend", "alloying_copper");
    public static final TagKey<Block> BONEMEAL_SOURCE_DRAGON_BONE = TagManager.BLOCKS.makeTogetherTag("bonemeal/source/dragon_bone");
    public static final TagKey<Block> BONEMEAL_TARGET_DRAGON_BONE = TagManager.BLOCKS.makeTogetherTag("bonemeal/target/dragon_bone");
    public static final TagKey<Block> BONEMEAL_SOURCE_WATER_GRASS = TagManager.BLOCKS.makeTag("betterend", "bonemeal/source/water_grass");
    public static final TagKey<Block> BONEMEAL_TARGET_WATER_GRASS = TagManager.BLOCKS.makeTag("betterend", "bonemeal/target/water_grass");

    public static void register() {
        EndTags.addEndGround(EndBlocks.THALLASIUM.ore);
        EndTags.addEndGround(EndBlocks.ENDSTONE_DUST);
        EndTags.addEndGround(EndBlocks.AMBER_ORE);
        EndTags.addEndGround(EndBlocks.CAVE_MOSS);
        ArrayList ITEM_HAMMERS = Lists.newArrayList();
        EndItems.getModItems().forEach(item -> {
            FoodProperties food;
            if (item.m_41472_() && (food = item.m_41473_()) != null) {
                float compost = (float)food.m_38744_() * food.m_38745_() * 0.18f;
                ComposterAPI.allowCompost((float)compost, (Item)item);
            }
            if (item instanceof EndHammerItem) {
                ITEM_HAMMERS.add(item);
            }
        });
        TagManager.BLOCKS.add(CommonBlockTags.END_STONES, (Object[])new Block[]{EndBlocks.ENDER_ORE, EndBlocks.BRIMSTONE});
        TagManager.BLOCKS.add(CommonBlockTags.END_STONES, (Object[])new Block[]{EndBlocks.BRIMSTONE});
        TagManager.BLOCKS.add(BlockTags.f_13033_, (Object[])new Block[]{EndBlocks.AETERNIUM_ANVIL});
        TagManager.BLOCKS.add(BlockTags.f_13079_, (Object[])new Block[]{EndBlocks.AETERNIUM_BLOCK});
        TagManager.ITEMS.add(ItemTags.f_13164_, (Object[])new Item[]{EndItems.AETERNIUM_INGOT});
        TagManager.BLOCKS.add(BlockTags.f_13069_, (Object[])new Block[]{EndBlocks.ENDER_ORE, EndBlocks.ETERNAL_PEDESTAL, EndBlocks.FLAVOLITE_RUNED_ETERNAL, EndBlocks.FLAVOLITE_RUNED});
        TagManager.ITEMS.add(CommonItemTags.IRON_INGOTS, (Object[])new Item[]{EndBlocks.THALLASIUM.ingot});
        TagManager.ITEMS.add(ALLOYING_IRON, (Object[])new Item[]{Items.f_41834_, Items.f_150964_, Items.f_151050_});
        TagManager.ITEMS.add(ALLOYING_GOLD, (Object[])new Item[]{Items.f_41833_, Items.f_150967_, Items.f_151053_});
        TagManager.ITEMS.add(ALLOYING_COPPER, (Object[])new Item[]{Items.f_150965_, Items.f_150966_, Items.f_151051_});
        TagManager.ITEMS.add(ItemTags.f_13156_, (Object[])new Item[]{EndItems.END_FISH_RAW, EndItems.END_FISH_COOKED});
        TagManager.BLOCKS.addOtherTags(BONEMEAL_TARGET_WATER_GRASS, new TagKey[]{CommonBlockTags.END_STONES});
    }

    public static void addEndGround(Block bl) {
        TagManager.BLOCKS.add(CommonBlockTags.END_STONES, (Object[])new Block[]{bl});
    }

    public static void addBiomeSurfaceToEndGroup(EndBiome b) {
        EndTags.addEndGround(b.getTopMaterial().m_60734_());
        EndTags.addEndGround(b.getAltTopMaterial().m_60734_());
        EndTags.addEndGround(b.getUnderMaterial().m_60734_());
    }
}

